set terminal pngcairo size 600, 600
set output 'plot_activity3.png'

set lmargin at screen 0.15
set rmargin at screen 0.95

TOP = 0.98
DY = 0.42

set multiplot
set offset 0,0,graph 0.05

unset xlabel
set xlabel 'time (fs)'
set ylabel 'Ionisation' offset 0
set tmargin at screen TOP-DY
set bmargin at screen TOP-2*DY
plot "results/off_resonance/pescel.na9p_offresonance" u 1:3 w l lw 3 title '(off resonance)',\
"results/on_resonance/pescel.na9p" u 1:3 w l title '(on resonance)'

set xtics format ''
unset xlabel
set ylabel 'Dipole moment (z) [a_0]' offset 1
set tmargin at screen TOP
set bmargin at screen TOP-1*DY
set ytics -1,0.5,1.5
plot "results/off_resonance/pdip.na9p_offresonance" u 1:4 w l lw 3 title '(off resonance)',\
"results/on_resonance/pdip.na9p" u 1:4 w l title '(on resonance)'

unset multiplot