set terminal pngcairo size 600, 900
set output 'plot_activity5.png'

set lmargin at screen 0.20
set rmargin at screen 0.95

TOP = 0.98
DY = 0.30

set multiplot
set offset 0,0,graph 0.05

set xrange [0:500]
set xlabel font ", 18"
set ylabel font ", 18"

set xtics font ", 16"
set ytics font ", 16"

set xlabel 'time [fs]'
set ylabel 'Ionisation' offset 0
set yrange [0:0.9]
set tmargin at screen TOP-2*DY
set bmargin at screen TOP-3*DY
plot "pescel.na9p" u 1:3 w l lw 3 lc "#721599" title ''

set xtics format ''
unset xlabel
set yrange [*:*]
set ylabel 'Dipole moment (z) [a_0]'  offset 0
set tmargin at screen TOP-1*DY
set bmargin at screen TOP-2*DY
set ytics -1,0.5,1
plot "pdip.na9p" u 1:4 w l lw 3 lc "#721599" title ''

set xtics format ''
unset xlabel
set ytics auto
set ylabel 'ionic r.m.s. [a_0]' offset 0
set tmargin at screen TOP
set bmargin at screen TOP-1*DY
plot "pgeomion.na9p" u 1:5 w l lw 3 lc "#721599" title ''

unset multiplot