set terminal pngcairo size 600, 900
set output 'plot_activity6_onedelay.png'

set lmargin at screen 0.20
set rmargin at screen 0.95

TOP = 0.98
DY = 0.30

set multiplot
set offset 0,0,graph 0.05

set xrange [0:500]
set xlabel font ", 18"
set ylabel font ", 18"

set xtics font ", 16"
set ytics font ", 16"

set xlabel 'time [fs]'
set ylabel 'Ionisation' offset 0
set tmargin at screen TOP-2*DY
set bmargin at screen TOP-3*DY
plot "delay1/pescel.na9p" u 1:3 w l lw 3 lc "#06570c" title '', "../activity_5/pescel.na9p" u 1:3 w l lw 3 lc "#721599" title ''

unset xtics
unset xlabel
set ylabel 'Dipole moment (z) [a_0]'  offset 0
set tmargin at screen TOP-1*DY
set bmargin at screen TOP-2*DY
set ytics -1,0.5,1
plot "delay1/pdip.na9p" u 1:4 w l lw 3 lc "#06570c" title '', "../activity_5/pdip.na9p" u 1:4 w l lw 3 lc "#721599" title ''

unset xtics
unset xlabel
set ytics auto
set ylabel 'ionic r.m.s. [a_0]' offset 0
set tmargin at screen TOP
set bmargin at screen TOP-1*DY
plot "../activity_5/pgeomion.na9p" u 1:5 w l lw 3 title ''

unset multiplot


reset session
set lmargin at screen 0.20
set rmargin at screen 0.95

TOP = 0.98
DY = 0.30

set output 'plot_activity6_twodelays.png'

set multiplot
set offset 0,0,graph 0.05

set xrange [0:500]
set xlabel font ", 18"
set ylabel font ", 18"

set xtics font ", 16"
set ytics font ", 16"


set xlabel 'time [fs]'
set ylabel 'Ionisation' offset 0
set tmargin at screen TOP-2*DY
set bmargin at screen TOP-3*DY
plot "delay2/pescel.na9p" u 1:3 w l lw 3 lc "red" title '', "delay1/pescel.na9p" u 1:3 w l lw 3 lc "#06570c" title '', "../activity_5/pescel.na9p" u 1:3 w l lw 3 lc "#721599" title ''

unset xtics
unset xlabel
set ylabel 'Dipole moment (z) [a_0]'  offset 0
set tmargin at screen TOP-1*DY
set bmargin at screen TOP-2*DY
set ytics -1,0.5,1
plot "delay2/pdip.na9p" u 1:4 w l lw 3 lc "red" title '', "delay1/pdip.na9p" u 1:4 w l lw 3 lc "#06570c" title '', "../activity_5/pdip.na9p" u 1:4 w l lw 3 lc "#721599" title ''

unset xtics
unset xlabel
set ytics auto
set ylabel 'ionic r.m.s. [a_0]' offset 0
set tmargin at screen TOP
set bmargin at screen TOP-1*DY
plot "../activity_5/pgeomion.na9p" u 1:5 w l lw 3 lc "#721599" title ''

unset multiplot
